<?php
/**
 * Documentation Page
 *
 * @since    1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>
<div class="tipi-block tipi-help">

	<div class="tipi-box tipi-xs-12 tipi-m-4 tipi-col tipi-col-first">
		<div class="tipi-content-area">
			<div class="tipi-title-with-i lr-cf">
				<span class="tipi-title-i"><i class="tipi-icon tipi-i-book-open"></i></span>
				<div class="tipi-title">
					<h3><?php esc_html_e( 'Documentation', 'lets-review' ); ?></h3>
				</div>
			</div>
			<div class="tipi-content">
				<div class="lr-cf tipi-content-text">
					<?php esc_html_e( 'The first place to go to whenever you have any questions about the plugin. Detailed instructions for all the plugin features.', 'lets-review' ); ?>
				</div>
				<a href="http://docs.codetipi.com/lets-review" class="button button-primary" target="_blank"><?php esc_html_e( 'Open documentation', 'lets-review' ); ?></a>
			</div>
		</div>
	</div>
	<div class="tipi-box tipi-xs-12 tipi-m-4 tipi-col ">
		<div class="tipi-content-area">
			<div class="tipi-title-with-i lr-cf">
				<span class="tipi-title-i"><i class="tipi-icon tipi-i-control-play"></i></span>
				<div class="tipi-title">
					<h3><?php esc_html_e( 'Video Tutorials', 'lets-review' ); ?></h3>
				</div>
			</div>
			<div class="tipi-content">
				<div class="lr-cf tipi-content-text">
					<?php esc_html_e( 'After the release of Let\'s Review v2, a big effort will be made to create multiple video tutorials to show how things work.', 'lets-review' ); ?>
				</div>
				<a href="https://www.youtube.com/playlist?list=PLs3BJTy4iIgfZn9CNyLUnV0pi5yyCLPSX" class="button button-primary" target="_blank"><?php esc_html_e( 'Watch Videos', 'lets-review' ); ?></a>
			</div>
		</div>
	</div>
	<div class="tipi-box tipi-xs-12 tipi-m-4 tipi-col tipi-col-last">
		<div class="tipi-content-area">
			<div class="tipi-title-with-i lr-cf">
				<span class="tipi-title-i"><i class="tipi-icon tipi-i-anchor"></i></span>
				<div class="tipi-title">
					<h3><?php esc_html_e( 'Support', 'lets-review' ); ?></h3>
				</div>
			</div>
			<div class="tipi-content">
				<div class="lr-cf tipi-content-text">
				<?php esc_html_e( 'If you can\'t find the answer in the documentation or video tutorials then feel to open a ticket in the Codetipi support system.', 'lets-review' ); ?>
				</div>
				<a href="http://codetipi.ticksy.com" class="button button-primary" target="_blank"><?php esc_html_e( 'Open Support', 'lets-review' ); ?></a>
			</div>
		</div>
	</div>
</div>
